require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Mechanics"

ST.addContributor(KEY, function(ctx)
    -- Inputs:
    --   ctx.level (number)     The current Mechanics level for the UI preview
    --   ctx.add(text:string)   Appends a formatted line to the tooltip body
    -- Outputs: none (adds lines to the tooltip)
    local lvl = ctx.getLevel()

    -- New Build 42 additions:
    -- At level 8/9/10 the player learns Basic / Intermediate / Advanced Mechanics respectively.

    if lvl >= 8 then
        ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
        ctx.add(ST.getText("IGUI_DST_Mechanics_val_Basic"))
    end
    if lvl >= 9 then
        ctx.add(ST.getText("IGUI_DST_Mechanics_val_Intermediate"))
    end
    if lvl >= 10 then
        ctx.add(ST.getText("IGUI_DST_Mechanics_val_Advanced"))
    end
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)
